
#include <iostream>
#include <unordered_map>
#import "C:\Program Files\eCADSTAR\eCADSTAR 2020.0\bin\eCS_scm.exe"

class COMInitializer {
public:
    COMInitializer()
    {
        CoInitializeEx(nullptr, COINITBASE_MULTITHREADED);
    }
    ~COMInitializer()
    {
        CoUninitialize();
    }
};

template <class IItemPtr>
class IEnumVARIANT_iterator {
public:
    using iterator_category = std::forward_iterator_tag;
    using value_type = IItemPtr;
    using difference_type = std::ptrdiff_t;
    using pointer = value_type*;
    using reference = value_type&;

    IEnumVARIANT_iterator() = default;
    IEnumVARIANT_iterator(IEnumVARIANTPtr p)
        : enumVariant_(p)
    {
        operator++();
    }

    IEnumVARIANT_iterator& operator++()
    {
        _variant_t v;
        ULONG c = 0;
        if (enumVariant_ && enumVariant_->Next(1, &v, &c) == S_OK) {
            v.pdispVal->QueryInterface<typename IItemPtr::Interface>(&item_);
        } else {
            enumVariant_ = nullptr;
            item_ = nullptr;
        }
        return *this;
    }

    operator bool() { return static_cast<bool>(item_); }

    bool operator==(const IEnumVARIANT_iterator& rhs) const noexcept { return item_ == rhs.item_; }
    bool operator!=(const IEnumVARIANT_iterator& rhs) const noexcept { return item_ != rhs.item_; }

    reference operator*() noexcept { return item_; }
    value_type operator*() const noexcept { return item_; }
    pointer operator->() noexcept { return &item_; }
    const pointer operator->() const noexcept { return &item_; }

private:
    IEnumVARIANTPtr enumVariant_;
    IItemPtr item_;
};

template <typename T>
auto begin(const _com_ptr_t<T>& p)
{
    return IEnumVARIANT_iterator<decltype(p->Item[0])> { p->_NewEnum };
}

template <typename T>
auto end(const _com_ptr_t<T>& p)
{
    return IEnumVARIANT_iterator<decltype(p->Item[0])> { nullptr };
}

int main(int argc, char* argv[])
{
    using namespace eCSSCHCOM;

    std::wcout.imbue(std::locale(""));

    //if (argc < 2) {
    //    return 1;
    //}

    COMInitializer co;

    ISchApplicationPtr app;

    app.GetActiveObject(__uuidof(SchApplication));

    //app->OpenDesign(argv[1]);

    std::wcout << L"Net, Connected Pins...\n";

    for (ISchNetPtr net : app->Design->Nets) {
        const _bstr_t& netLabel = net->InstanceLabel;
        if (netLabel.length() == 0) {
            continue;
        }
        std::wcout << netLabel;
        for (ISchPinPtr pin : net->ConnectedPins) {
            const _bstr_t& reference = pin->Component->ReferenceDesignator;
            if (reference.length() == 0) {
                continue;
            }
            std::wcout << L", " << reference << L":" << pin->ID;
        }
        std::wcout << L"\n";
    }

    //app->Quit();
    system("pause");

    return 0;
}
