#include "stdafx.h"
#include <iostream>
#include <unordered_map>
#import "C:\Program Files\eCADSTAR\eCADSTAR 2019.0\bin\eCS_pcb.exe"

class COMInitializer
{
public:
	COMInitializer()
	{
		CoInitializeEx(nullptr, COINITBASE_MULTITHREADED);
	}
	~COMInitializer()
	{
		CoUninitialize();
	}
};

template<class IItemPtr>
class IEnumVARIANT_iterator
{
public:
	using iterator_category = std::forward_iterator_tag;
	using value_type = IItemPtr;
	using difference_type = std::ptrdiff_t;
	using pointer = value_type * ;
	using reference = value_type & ;

	IEnumVARIANT_iterator() = default;
	IEnumVARIANT_iterator(IEnumVARIANTPtr p) :enumVariant_(p)
	{
		operator++();
	}

	IEnumVARIANT_iterator& operator++()
	{
		_variant_t v;
		ULONG c = 0;
		if (enumVariant_ && enumVariant_->Next(1, &v, &c) == S_OK)
		{
			v.pdispVal->QueryInterface<typename IItemPtr::Interface>(&item_);
		}
		else
		{
			enumVariant_ = nullptr;
			item_ = nullptr;
		}
		return *this;
	}

	operator bool() { return static_cast<bool>(item_); }

	bool operator==(const IEnumVARIANT_iterator& rhs) const noexcept { return item_ == rhs.item_; }
	bool operator!=(const IEnumVARIANT_iterator& rhs) const noexcept { return item_ != rhs.item_; }

	reference operator*() noexcept { return item_; }
	value_type operator*() const noexcept { return item_; }
	pointer operator->() noexcept { return &item_; }
	const pointer operator->() const noexcept { return &item_; }

private:
	IEnumVARIANTPtr enumVariant_;
	IItemPtr item_;
};

template<typename _IIID>
auto begin(const _com_ptr_t<_IIID>& p)
{
	return IEnumVARIANT_iterator<decltype(p->Item[0])>{ p->_NewEnum };
}

template<typename _IIID>
auto end(const _com_ptr_t<_IIID>& p)
{
	return IEnumVARIANT_iterator<decltype(p->Item[0])>{ nullptr };
}

template<class IPropertiesPtr>
std::unordered_map<std::wstring, std::wstring> to_dictionary(IPropertiesPtr properties)
{
	std::unordered_map<std::wstring, std::wstring> map;
	for (auto property : properties)
	{
		map.insert(std::make_pair(property->Name, property->Value));
	}
	return map;
}

int main(int argc, char* argv[])
{
	using namespace eCSPCBCOM;

	std::wcout.imbue(std::locale(""));

	if (argc < 2)
	{
		return 1;
	}

	COMInitializer co;

	IPCBApplicationPtr app;

	app.CreateInstance(__uuidof(PCBApplication));

	app->OpenDesign(argv[1]);

	const std::wstring propertyNames[] =
	{
		L"Reference Designator",
		L"Part Name",
		L"Description"
	};

	bool isFirst = true;
	for (const auto& name : propertyNames)
	{
		if (!isFirst)
		{
			std::wcout << L"\t";
		}
		std::wcout << name.c_str();
		isFirst = false;
	}
	std::wcout << L"\n";

	for (IPCBComponentPtr component : app->CurrentDesign->Components)
	{

		auto properties = to_dictionary(component->Part->Properties);

		const int DESCRIPTION_PROP = 2;
		std::wstring description = properties[propertyNames[DESCRIPTION_PROP]];

		std::wcout << component->ReferenceDesignator << L"\t" << component->Part->Name << L"\t" << description.c_str();

		std::wcout << L"\n";
	}

	app->Quit();

	system("pause");

	return 0;
}
