﻿using System;
using System.Runtime.InteropServices;
using eCSSCHCOM;

namespace CsSchNetListExample
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Net, Connected Pins...");
            var app = Marshal.GetActiveObject("eCADSTAR.SchematicEditor.Application") as SchApplication;
            foreach (SchNet net in app.Design.Nets)
            {
                var netLable = net.InstanceLabel;
                if (netLable.Equals(string.Empty))
                {
                    continue;
                }
                Console.Write(netLable);
                foreach(SchPin pin in net.ConnectedPins)
                {
                    var reference = pin.Component.ReferenceDesignator;
                    if (reference.Equals(string.Empty))
                    {
                        continue;
                    }
                    Console.Write($", {reference}:{pin.ID}");
                }
                Console.Write("\n");
            }
        }
    }
}
