﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PCBScriptingCSharp
{
    class Program
    {
        static void Main(string[] args)
        {
            if(args.Length < 1)
            {
                return;
            }
            var app = new eCSPCBCOM.PCBApplication();
            app.OpenDesign(args[0]);
            Console.WriteLine("{0}\t{1}\t{2}", "Reference Designator", "Part Name", "Description");
            foreach (eCSPCBCOM.PCBComponent component in app.CurrentDesign.Components)
            {
                var properties = component.Part.Properties.Cast<eCSPCBCOM.IProperty>().ToDictionary(x => x.Name, x => x.Value);
                string description = "";
                if (properties.ContainsKey("Description"))
                {
                    description = properties["Description"];
                }
                Console.WriteLine(component.ReferenceDesignator + "\t" + component.Part.Name + "\t" + description);
            }
            app.Quit();
            Console.ReadLine();
        }
    }
}
